
import cadquery as cq

# Parameters for the main square and the small rectangles
main_square_side = 10.0
rectangle_width = 0.5
rectangle_height = 1.0
extrude_depth = 0.5

# Create the main square
result = cq.Workplane("XY").box(main_square_side, main_square_side, extrude_depth)

# Create the small rectangles on the left and right edges of the square
result = (result.faces(">X").workplane(centerOption="ProjectedOrigin") # Select the right face
               .rect(rectangle_width, rectangle_height).extrude(extrude_depth))
result = (result.faces("<X").workplane(centerOption="ProjectedOrigin") # Select the left face
               .rect(rectangle_width, rectangle_height).extrude(extrude_depth))

# Save the output
result.val().exportStl("Refine_2.stl")
