
import cadquery as cq

# Parameters for the cylinder and holes
diameter = 100.0  # Diameter of the main cylinder
height = 20.0  # Height of the main cylinder
center_hole_diameter = diameter / 8  # Diameter of the center hole
small_hole_diameter = center_hole_diameter / 4  # Diameter of the small holes
small_hole_offset = center_hole_diameter  # Offset of the small holes from the center

# Create the main cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the center hole
result = result.faces(">Z").workplane().hole(center_hole_diameter)

# Create the small holes in a triangular formation
for angle in [0, 120, 240]:
    result = result.faces(">Z").workplane().transformed(rotate=(0, 0, angle)).center(small_hole_offset, 0).hole(small_hole_diameter)

# Export the result
result.val().exportStl("Refine_1.stl")
