
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 1.5  # Length of the rectangle
width = 0.02  # Width of the rectangle
thickness = 1.22  # Thickness of the rectangle
hole_diameter = 0.01  # Diameter of the holes

# Create the rectangle
object = (
    cq.Workplane("XY")
    .box(length, width, thickness)
)

# Create the holes
for i in range(3):
    object = (
        object.faces(">Z")
        .workplane()
        .center(length / 4, (i - 1) * width / 4)
        .hole(hole_diameter)
    )

# Export the result
object.val().exportStl("Refine_2.stl")
