
import cadquery as cq

# Parameters for the bucket and handle
bucket_height = 10.0
bucket_radius = 5.0
bucket_thickness = 0.5
handle_diameter = 0.5
handle_length = 2 * bucket_radius + 2.0

# Create the outer cylinder of the bucket
bucket = cq.Workplane("XY").circle(bucket_radius).extrude(bucket_height)

# Create the inner cylinder of the bucket
bucket = bucket.faces(">Z").workplane().circle(bucket_radius - bucket_thickness).cutBlind(-bucket_height + bucket_thickness)

# Create the handle
handle = cq.Workplane("YZ", origin=(0, bucket_radius + handle_diameter / 2, bucket_height - bucket_thickness)).circle(handle_diameter / 2).extrude(handle_length)

# Combine the bucket and handle
result = bucket.union(handle)

# Export the result
result.val().exportStl("Generated.stl")
