
import cadquery as cq
import math

# Create a regular hexagon
hexagon = cq.Workplane("XY").polygon(6, 10).extrude(5)

# Create a smaller square on top of the hexagon
square = cq.Workplane("XY").workplane(offset=5).transformed(rotate=(0, 0, 45)).rect(5, 5).extrude(5)

# Combine the hexagon and the square
result = hexagon.union(square)

# Export the result
result.val().exportStl("Generated.stl")
