
import cadquery as cq

# Define the dimensions
block_width = 20.0
block_height = 10.0
block_depth = block_height / 4
hole_width = block_width * 5 / 12
hole_height = block_height * 7 / 10
hole_radius = hole_height / 7  # Updated radius for a smaller fillet

# Create the block
block = cq.Workplane("front").rect(block_width, block_height).extrude(block_depth)

# Create the holes
holes = (
    cq.Workplane("front")
    .moveTo(-block_width / 4, 0)
    .rect(hole_width, hole_height)
    .extrude(block_depth, combine=True)
    .edges("|Z").fillet(hole_radius)  # Fillet the corners after extruding
)
holes = holes.union(holes.mirror("XZ"))

# Subtract the holes from the block
result = block.cut(holes)

# Export the result
result.val().exportStl("Refine_2.stl")
