
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(10, 20).extrude(5)

# Create the L-shaped block
l_block = (
    cq.Workplane("XY")
    .workplane(offset=5)
    .moveTo(-5, 10)
    .lineTo(5, 10)
    .lineTo(5, 5)
    .lineTo(-5, 5)
    .close()
    .extrude(5)
)

# Combine the base and the L-shaped block
result = base.union(l_block)

# Export the result
result.val().exportStl("Generated.stl")
