
import cadquery as cq
import os

# Check if the file exists and if yes, then remove it
if os.path.exists("Refine_2.stl"):
    os.remove("Refine_2.stl")

# Create a sketch of a long rectangle
rectangle = cq.Workplane("XY").rect(80, 20)

# Extrude the rectangle by a small amount to create a 3D object
rectangle3D = rectangle.extrude(5)

# Draw a sketch of a small square with rounded edges
square = cq.Workplane("XY").rect(10, 10)

# Extrude the square by a small amount to create a 3D object
cutout = square.extrude(5)

# Draw two sketches of two cutouts
cutout1 = cutout.translate((30,0,2.5))
cutout2 = cutout.translate((50,0,2.5))

# Combine the 3D rectangle and the square cutouts
result = rectangle3D.cut(cutout1).cut(cutout2)

# Export the result
result.val().exportStl("Refine_2.stl")
