
import cadquery as cq

# Define the dimensions
length_vertical = 0.28
width = 0.01
thickness = 0.005
length_horizontal = length_vertical / 4

# Adjusting the top of the horizontal rectangle to be closer to the top of the vertical rectangle
vertical_offset = length_vertical / 4 * 3

# Create the vertical rectangle
result = cq.Workplane("front").rect(width, length_vertical).extrude(thickness)

# Create the horizontal rectangle
result = result.faces(">Z").workplane().center(0, vertical_offset).rect(width, length_horizontal).extrude(thickness)

# Export the result
result.val().exportStl("Refine_2.stl")
