
import cadquery as cq

# Define the dimensions
width = 30.0
height = 10.0
depth = 2.0
cutout_width = 2.0
cutout_height_left = 6.0
cutout_height_right = 2.0

# Create the base rectangle
result = cq.Workplane("front").rect(width, height).extrude(depth)

# Create the cutouts
result = result.faces("<X").workplane().center(width/2, 0).rect(cutout_width, cutout_height_left).cutBlind(-depth)
result = result.faces(">X").workplane().center(-width/2, 0).rect(cutout_width, cutout_height_right).cutBlind(-depth)

# Export the result
result.val().exportStl("Refine_1.stl")
