
import cadquery as cq
import math

# Define the dimensions
base_length = 0.72  # Length of the base
top_length = 0.63  # Length of the top
height = 0.01  # Height of the trapezoid
extrude_amount = 0.01  # Amount to extrude the sketch

# Calculate the angles for the trapezoid
angle = math.radians(70)  # Convert the angle to radians
half_base = base_length / 2
half_top = top_length / 2
adjacent = (half_base - half_top)  # The length of the line adjacent to the angle

# Calculate the coordinates for the trapezoid
x1 = -half_base
y1 = -height / 2
x2 = -half_top
y2 = height / 2
x3 = half_top
y3 = height / 2
x4 = half_base
y4 = -height / 2

# Create the trapezoid
result = (
    cq.Workplane("front")
    .moveTo(x1, y1)
    .lineTo(x2, y2)
    .lineTo(x3, y3)
    .lineTo(x4, y4)
    .close()
    .extrude(extrude_amount)
)

# Export the result
result.val().exportStl("Refine_2.stl")
