
import cadquery as cq

# Create the first rectangle
first_rectangle = cq.Workplane("front").rect(10, 20).extrude(1)

# The initial code was missing the correct positioning of the second rectangle.
# It should connect to the right edge of the first one and start halfway up.
# We need to adjust the Y position to be 10 + 10/2 = 15, as the first rectangle's height is 20.
second_rectangle = cq.Workplane("front").transformed(offset=(5, 15, 0)).rect(5, 10).extrude(1)

# Combine the two rectangles
result = first_rectangle.union(second_rectangle)

# Export the result with the updated filename specification.
result.val().exportStl("Refine_1.stl")
