
import cadquery as cq

# Parameters for the cylinder and cutting tool
diameter = 10  # Diameter of the cylinder
height = 20  # Height of the cylinder

# Create cylinder
cylinder = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Calculate section width to cut (approximately 1/4th of the diameter)
cut_width = diameter / 4
cut_length = height / 4

# Create cutting tool that removes approximately 1/4th the length and diameter of the original cylinder
# A wedge shaped cutting tool
cutting_tool = (cq.Workplane("XY")
                .workplane(offset=height - cut_length)
                .center(diameter / 4, 0)  # Moving the center of rectangle to outset
                .rect(cut_width * 2, diameter * 2)  # Making the rectangle big enough
                .extrude(cut_length))

# Cut the cylinder with the cutting tool
result = cylinder.cut(cutting_tool)

# Export the result in STL
result.val().exportStl("Refine_1.stl")
