
import cadquery as cq

# Define the dimensions
length = 10.0
width = 5.0
height = 0.5

# Create the first rectangle
result = cq.Workplane("XY").box(length, width, height)

# Ensure the second rectangle is positioned and aligned correctly at the edge
# Create the second rectangle perpendicular to the first one
result = result.faces(">Z").workplane().transformed(offset=(-width/2, 0, height/2), rotate=(90, 0, 0)).box(length, width, height)

# Export the result with a refined name that corresponds to the task's steps
result.val().exportStl("Refine_2.stl")
