
import cadquery as cq

# Create the first cylinder
cylinder1 = cq.Workplane("XY").circle(10).extrude(20)

# The second cylinder should connect to the center of the first cylinder's base (changing to top for operational logic).
cylinder2 = (
    cq.Workplane("XY")
    .transformed(offset=(0, 0, 20))  # Staying at the top of the first cylinder
    .circle(5)
    .extrude(20)
)

# The third cylinder should connect to the top of the second cylinder,
# it should have a shorter height but larger diameter.
cylinder3 = (
    cq.Workplane("XY")
    .transformed(offset=(0, 0, 40))  # At the top of the second cylinder
    .circle(15)
    .extrude(10)
)

# Combine the cylinders
result = cylinder1.union(cylinder2).union(cylinder3)

# Create the cutout extending through all cylinders
cutout = cq.Workplane("XY").circle(2).extrude(50)

# Subtract the cutout from the result
result = result.cut(cutout)

# Export the result
result.val().exportStl("Refine_2.stl")
