
import cadquery as cq

# Define the parameters of the annulus
outer_radius = 10.0
inner_radius = 5.0
thickness = 2.0

# Create the annulus
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(thickness)
)

# Export the result
result.val().exportStl("Generated.stl")
