
import cadquery as cq

# Create a bigger circle and extrude it
result = cq.Workplane("XY").circle(10.0).extrude(5.0)

# Create a slightly smaller extruded circle on top of the first circle
result = result.faces(">Z").workplane().circle(8.0).extrude(5.0)

# Save the output with the updated file name
result.val().exportStl("Refine_2.stl")
