
import cadquery as cq

# Parameters for the ring
outer_radius = 10.0
inner_radius = 5.0
thickness = 2.0

# Create the ring
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(thickness)
)

# Export the result to STL with the new specified name
result.val().exportStl("Refine_2.stl")
