
import cadquery as cq

# Parameters for the cylinder
outer_radius = 10.0  # Outer radius of the cylinder
inner_radius = 5.0  # Inner radius of the cylinder (medium size)
height = 100.0  # Height of the cylinder (very long)

# Create the outer cylinder
result = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the inner cylinder
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtract the inner cylinder from the outer cylinder to create the hollow cylinder
result = result.cut(inner_cylinder)

# Corrected the file name per requirement
result.val().exportStl("Refine_2.stl")
