
import cadquery as cq

# Define the square's side length and the extrusion height
side_length = 10.0  # This creates a square base
extrusion_height = 100.0  # Increased the height to emphasize 'extensive' extrusion

# Create a square base then perform an extensive extrusion on it
result = (
    cq.Workplane("XY")
    .rect(side_length, side_length)  # Ensures the base is square
    .extrude(extrusion_height)  # Perform an extensive extrusion
)

# Export the result to an STL file with a new file name to reflect the modification
result.val().exportStl("Refine_2.stl")
