
import cadquery as cq

# Adjusted parameters for the cylinder and hole
diameter = 200.0  # Diameter of the cylinder 
height = 10.0  # Height of the cylinder
hole_diameter = 20.0  # Increase the diameter of the hole for visibility

# Create the cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the hole
result = result.faces(">Z").workplane().hole(hole_diameter)

# Export the adjusted model
result.val().exportStl("Refine_2.stl")
