
import cadquery as cq

# Define the dimensions
rect_length = 50.0  # Length of the rectangle
rect_width = 10.0   # Width of the rectangle
rect_height = 5.0   # Height of the rectangle
cylinder_radius = rect_width / 3  # Radius of the cylinder
cylinder_height = rect_height * 2  # Make the cylinder twice as high as the rectangle

# Create the rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Create the cylinder
# Positioning the cylinder very close to the edge of the rectangle on one side
cylinder_position = rect_length - cylinder_radius
result = result.faces(">Y").workplane().moveTo(cylinder_position, 0).circle(cylinder_radius).extrude(cylinder_height)

# Export the result with the amended file name
result.val().exportStl("Refine_1.stl")
