
import cadquery as cq

# Define dimensions
rectangle_length = 15.0  # length of the rectangle
rectangle_width = 10.0   # width of the rectangle
rectangle_thickness = 0.5  # thickness of the rectangle
rod_width = 1.0  # width of the small rod
rod_length = 1.0  # length of the small rod
rod_height = 45.0  # height of the rod, which is 3 times the rectangle length

# Create the base rectangle
result = (
    cq.Workplane("XY")
    .rect(rectangle_length, rectangle_width)
    .extrude(rectangle_thickness)
)

# Positioning the rod at the exact corner (-X, -Y direction from the center of the rectangle)
result = (
    result
    .faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .transformed(offset=(-rectangle_length / 2, rectangle_width / 2, 0))
    .rect(rod_length, rod_width)
    .extrude(rod_height)
)

# Export the result with the proper file name
result.val().exportStl("Refine_2.stl")
