
import cadquery as cq

# Define the dimensions
width = 10.0   # Width of the square
length = 2 * width  # Length should be twice the width

# Create a rectangle with updated dimensions and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(5.0)  # Extrude the rectangle to create a 3D object
)

# Save the output
result.val().exportStl("Refine_2.stl")
