
import cadquery as cq

# Define the dimensions of the original and cutout prisms
length = 100.0
width = 20.0
height = 20.0
cutout_length = length / 4
cutout_height = height * 3 / 4

# Create the original prism
result = cq.Workplane("XY").box(length, width, height)

# Create the cutout prism
cutout = (
    cq.Workplane("XY")
    .workplane(offset=height - cutout_height)
    .moveTo(length / 2 + cutout_length / 2, 0)
    .rect(cutout_length, width)
    .extrude(cutout_height)
)

# Subtract the cutout from the original prism
result = result.cut(cutout)

# Export the result
result.val().exportStl("Generated.stl")
