
import cadquery as cq

# Define the dimensions of the original and cutout prisms
length = 100.0
width = 20.0
height = 20.0
cutout_length = length / 4
cutout_height = height * 3 / 4
cutout_width = width

# Create the original prism
result = cq.Workplane("XY").box(length, width, height)

# Create the cutout prism from the right side
cutout = (
    cq.Workplane("XY")
    .workplane(offset=0)
    .moveTo(length - cutout_length, 0)  # Correct the placement to the right end
    .rect(cutout_length, cutout_width)  # Use the same width as the original for the cutout width
    .extrude(cutout_height)  # This should be extruded towards the positive Z-direction
)

# Subtract the cutout from the original prism
result = result.cut(cutout)

# Export the corrected result
result.val().exportStl("Refine_2.stl")
