
import cadquery as cq

# Since the instructions specify a "very long" rectangle, adjust the length accordingly
length = 20  # increasing the length to make it very long
height = 1
thickness = 0.1
hole_radius = 0.25
semi_circle_radius = 0.5
hole_offset = 0.75  # place hole near the semi-circle center but towards the end

# Create a workplane
result = cq.Workplane("front")

# Draw the outline of the plate
result = result.moveTo(-length / 2, 0)\
    .lineTo(length / 2, 0)\
    .threePointArc((length / 2 + semi_circle_radius, semi_circle_radius), (length / 2, height))\
    .lineTo(-length / 2, height)\
    .threePointArc((-length / 2 - semi_circle_radius, semi_circle_radius), (-length / 2, 0))

# Extrude it to create the plate
result = result.close().extrude(thickness)

# Create the holes
result = result.faces(">Z").workplane()\
    .center(length / 2 - hole_offset, height / 2).hole(2 * hole_radius)\
    .center(-length + 2 * hole_offset, 0).hole(2 * hole_radius)  # shift center for second hole

# Export the result
result.val().exportStl("Refine_1.stl")
