
import cadquery as cq

# Increased length for a "very long" rectangle and other specifications
length = 20  # Very long rectangle
height = 1
thickness = 0.1
hole_radius = 0.25
semi_circle_radius = 0.5
hole_offset = 0.75  # Adjusted hole offsets

# Create a workplane
result = cq.Workplane("front")

# Draw the outline of the plate with semi-circular ends
result = result.moveTo(-length / 2, 0)\
    .lineTo(length / 2, 0)\
    .threePointArc((length / 2 + semi_circle_radius, semi_circle_radius), (length / 2, height))\
    .lineTo(-length / 2, height)\
    .threePointArc((-length / 2 - semi_circle_radius, semi_circle_radius), (-length / 2, 0))

# Extrude it to create the plate
result = result.close().extrude(thickness)

# Correcting hole positions to be near the semi-circles
result = result.faces(">Z").workplane()\
    .center(length / 2 - hole_offset, height / 2).hole(2 * hole_radius)\
    .center(-(length - 2 * hole_offset), 0).hole(2 * hole_radius)  # Correct position for second hole

# Export the revised result as STL
result.val().exportStl("Refine_2.stl")
