
import cadquery as cq

# Create a long rectangle and extrude it
result = cq.Workplane("front").rect(100, 10).extrude(10)

# Adjusting the positions of the holes to be closer to the ends of the rectangle
# Now placing holes at 5 units from each end of the 100 unit length rectangle
result = result.faces(">Z").workplane().pushPoints([(-47.5, 0), (47.5, 0)]).hole(2)

# Save the output
result.val().exportStl("Refine_2.stl")
