
import cadquery as cq

# Create a rectangle and extrude it
result = cq.Workplane("XY").rect(10, 20).extrude(5)

# Create a circle positioned above the midpoint of the rectangle and negatively extrude it to create a hole
result = result.faces(">Z").workplane().circle(2).cutThruAll()

# Correct the slit's position to start at the center of the circle and end precisely at the shorter edge of the rectangle
# Shift the slit to line up with the circle and rectangle axis correctly
# Calculate the needed position shift to center the slit starting from the circle's center
result = result.faces(">Z").workplane().center(0, 5).rect(0.2, 10, centered=False).cutThruAll()

# Save the output with the corrected file name
result.val().exportStl("Refine_2.stl")
