
import cadquery as cq

# Create a workplane
result = cq.Workplane("front")

# Create a rectangle and extrude it
result = result.rect(10, 10).extrude(5)

# Create a large circle in the center of the rectangle and cut it
result = result.faces(">Z").workplane().hole(4)

# Create two small circles on the left and right of the large circle and cut them
result = result.faces(">Z").workplane().center(-3, 0).hole(1)
result = result.faces(">Z").workplane().center(3, 0).hole(1)

# Export the result
result.val().exportStl("Generated.stl")
