
import cadquery as cq

# Define the dimensions of the U-shape and the rectangle
U_width = 10.0
U_height = 20.0
U_thickness = 2.0
rectangle_width = U_width + 2*U_thickness  # Ensure rectangle is wider than U’s width
rectangle_height = U_thickness

# Create the U-shaped sketch
U_shape = cq.Workplane("front").moveTo(-U_width/2, 0).vLine(U_height).hLine(U_width).vLine(-U_height).close()

# Fill in the empty space of the U-shape
U_shape_filled = U_shape.moveTo(-U_width/2 + U_thickness, U_thickness).vLine(U_height - 2*U_thickness).hLine(U_width - 2*U_thickness).vLine(-(U_height - 2*U_thickness)).close()

# Correct placement and creation of the rectangle to close the U-shape
Rectangle_part = cq.Workplane("front").rect(rectangle_width, rectangle_height).extrude(U_thickness)

# Translate the rectangle to correct position to close the U-shape
translated_rectangle = Rectangle_part.translate((0, U_height, 0))

# Combine the filled U-shape with the translated rectangle
combined_shape = U_shape_filled.union(translated_rectangle)

# Extrude the resulting sketch to form a 3D object
result = combined_shape.extrude(U_thickness)

# Save the output
result.val().exportStl("Refine_1.stl")
