
import cadquery as cq

# Create a flat square base instead of a cube
result = cq.Workplane("XY").rect(10, 10).extrude(0.1)  # Using a small extrusion to create a flat square 

# Create a tiny rectangle in the center of the square and cut through
result = result.faces(">Z").workplane().rect(1, 1).cutThruAll()  # Ensure the cut is through the tiny thickness

# Save the output with the updated name as instructed
result.val().exportStl("Refine_1.stl")
