
import cadquery as cq

# Define the dimensions of the outer and inner squares
outer_size = 10.0  # side length of the outer square
inner_size = 8.0   # side length of the inner square, should be smaller than outer_size
length = 20.0      # extrude length

# Create the outer square and extrude it
result = cq.Workplane("XZ").rect(outer_size, outer_size).extrude(length)

# Create the inner square and extrude negatively to create a hole
# Assuming cutting should happen throughout the full length uniformly
result = result.faces(">Y").workplane().rect(inner_size, inner_size).cutBlind(-length)

# Export the modified result with changed file name for clarity
result.val().exportStl("Refine_1.stl")
