
import cadquery as cq

# Create a parallelogram
parallelogram = cq.Workplane("XY").polyline([(0, 0), (4, 0), (5, 2), (1, 2)]).close()

# Extrude the parallelogram
extruded = parallelogram.extrude(10)

# Draw a square inside the extruded parallelogram
square = extruded.faces(">Z").workplane().rect(3, 3)

# Negatively extrude the square to create a hole
result = square.cutThruAll()

# Save the output
result.val().exportStl("Generated.stl")
