
import cadquery as cq

# Adjusted points to refine the obtuse angles close to 180 degrees for the top two edges.
pts = [
    (0, 0),          # Bottom left
    (2, 0),          # Bottom right
    (2.8, 1),        # Right middle, modified point for subtler angle
    (1.5, 1.8),      # Top right, new breaking point to facilitate nearly 180 degree angle
    (0.5, 1.8),      # Top left, new breaking point to create another nearly 180 degree angle
    (-0.8, 1)        # Left middle, modified point for subtler angle
]

# Create the workplane and the modified pentagon
result = cq.Workplane("XY").polyline(pts).close()

# Extrude to create a 3D object
result = result.extrude(1)

# Export the result with the new filename for clarity
result.val().exportStl("Refine_2.stl")
