
import cadquery as cq

# Parameters for the cylinder
outer_radius = 10.0
inner_radius = 5.0
height = 100.0

# Create the outer cylinder
outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the inner cylinder
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtract the inner cylinder from the outer cylinder to create a hollow cylinder
hollow_cylinder = outer_cylinder.cut(inner_cylinder)

# Properly position and cut a semi-circular shape in the middle of the cylinder.
# The semi-circle cut is positioned on the XZ plane at half the height and should affect the full depth
cut_shape = cq.Workplane("XZ").workplane(offset=height/2).circle(outer_radius).extrude(-height/2, both=True)
result = hollow_cylinder.cut(cut_shape)

# Export the result
result.val().exportStl("Refine_2.stl")
