
import cadquery as cq

# Define the dimensions of the isosceles trapezoid
base = 10.0
top = 5.0
height = 7.0

# Calculate the horizontal shift needed to center the top edge over the base
shift = (base - top) / 2.0

# Create the isosceles trapezoid
result = (
    cq.Workplane("front")
    .moveTo(-base / 2.0, 0)
    .lineTo(-top / 2.0 - shift, height)
    .lineTo(top / 2.0 + shift, height)
    .lineTo(base / 2.0, 0)
    .close()
    .extrude(1.0)  # Extrude the 2D trapezoid into a 3D object
)

# Export the result to STL with the correct filename specified
result.val().exportStl("Refine_2.stl")
