
import cadquery as cq

# Create a workplane
result = cq.Workplane("XY")

# Create a large annulus shape
result = result.circle(10).circle(5)  # Outer radius 10, inner radius 5

# Extrude the annulus shape
result = result.extrude(5)

# Select the bottom face of the cylinder
result = result.faces("<Z").workplane()

# Create a circle at the bottom of the cylinder to close it
# The circle should match the outer diameter
result = result.circle(10).extrude(-0.1)  # Extruding a small negative amount to ensure it closes up

# Save the updated output
result.val().exportStl("Refine_1.stl")
