
import cadquery as cq

# Define the dimensions of the brick
brick_length = 1.0
brick_width = 1.0
brick_height = 1.8
circle_height = brick_height / 7
circle_diameter = brick_width / 2

# Create the base of the brick with updated shell logic
brick = (
    cq.Workplane("XY")
    .box(brick_length, brick_width, brick_height)
    .faces("<Z")
    .shell(-0.1)   # Assuming 0.1 results in hollow block without deforming exterior
)

# Create the circle on top of the brick
brick = (
    brick.faces(">Z")
    .workplane(centerOption="CenterOfMass")
    .circle(circle_diameter / 2)
    .extrude(circle_height)
)

# Export the model as STL
brick.val().exportStl("Refine_1.stl")
