
import cadquery as cq

# Define the dimensions
width = 15.0
height = 1.0
thickness = 0.2
hole_width = (width / 3.0) - 0.5  # slightly smaller than one third of the width
hole_height = height / 2.0
hole_spacing = width / 6.0

# Create the base rectangle
result = cq.Workplane("XY").box(width, height, thickness)

# Create the holes - adjusting the placement to ensure no overlap with edges or each other
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")  # centering the workplane
    .rect(hole_width + hole_spacing, hole_height, forConstruction=True)  # position helper
    .vertices("<XY")
    .rect(hole_width, hole_height)
    .vertices(">XY")
    .rect(hole_width, hole_height)
    .cutBlind(-thickness)
)

# Export the result
result.val().exportStl("Refine_1.stl")
