
import cadquery as cq

# Create a rectangle and extrude it
result = cq.Workplane("front").rect(10, 20).extrude(30)

# Create a hollow cylinder in the middle of the rectangle
result = result.faces(">Z").workplane().circle(5).cutThruAll()

# Save the output
result.val().exportStl("Generated.stl")
