
import cadquery as cq

# Define the side length and radius of the rounded square
side_length = 10.0
radius = 1.0

# Create a rounded square by making a square, filleting the corners, and then extruding
result = (
    cq.Workplane("XY")
    .rect(side_length, side_length, forConstruction=True)
    .vertices()
    .fillet(radius)  # Apply fillet on the 2D shape corners
    .close()
    .extrude(5.0)  # Extrude the rounded square to create a 3D object
)

# Export the result to an STL file with the updated filename
result.val().exportStl("Refine_2.stl")
