
import cadquery as cq

# Define the dimensions
square_length = 10.0
square_width = 10.0
small_extrude_amount = 1.0  # Small extrusion for the base square
rectangle_length = square_length
rectangle_width = square_width / 2.0
large_extrude_amount = 100.0  # Large extrusion for the rectangle to form the pillar

# Create the base square and extrude it along the Y-axis
result = (
    cq.Workplane("XZ")
    .rect(square_length, square_width)
    .extrude(small_extrude_amount)
)

# Switch to a workplane offset from the top face of the base square to create the rectangle
result = (
    result.faces(">Y")  # Select the top face of the base square
    .workplane(centerOption="CenterOfMass")  # Center the workplane on the face
    .rect(rectangle_length, rectangle_width)  # Draw the rectangle
    .extrude(large_extrude_amount)  # Extrude the rectangle to form the pillar
)

# Export the result as STL
result.val().exportStl("Refine_2.stl")
