
import cadquery as cq

# Define the dimensions of the trapezoids and their placement
base1 = 10.0
base2 = 5.0
height = 20.0
extrude_dist1 = 10.0
extrude_dist2 = 2.0
offset_distance = 5.0  # Offset from the side of the first trapezoid

# Create the first trapezoid
result = (
    cq.Workplane("front")
    .lineTo(base1 / 2, 0)
    .lineTo(base2 / 2, height)
    .lineTo(-base2 / 2, height)
    .lineTo(-base1 / 2, 0)
    .close()
    .extrude(extrude_dist1)
)

# Create the second trapezoid. Adjust its placement to start from the back edge of first trapezoid
result2 = (
    cq.Workplane("front")
    .workplane(offset=extrude_dist1 - extrude_dist2)  # Start lower to extrude less
    .transformed(offset=cq.Vector(-offset_distance, 0, 0))  # Move it to one side
    .lineTo((base1 + 2) / 2, 0)
    .lineTo((base2 + 2) / 2, height + 2)
    .lineTo(-(base2 + 2) / 2, height + 2)
    .lineTo(-(base1 + 2) / 2, 0)
    .close()
    .extrude(extrude_dist2)
)

# Combine the two trapezoids
result = result.union(result2)

# Export the result with the adjusted name as per the requirements
result.val().exportStl("Refine_1.stl")
