
import cadquery as cq

# Define the points for the pentagon
points = [(0, 0), (10, 0), (12, 5), (5, 10), (-2, 5)]

# Create the workplane and the pentagon
result = cq.Workplane("front").polyline(points).close()

# Extrude the pentagon to create a pentagonal prism
result = result.extrude(10)

# Export the result
result.val().exportStl("Generated.stl")
