
import cadquery as cq

# Define the dimensions of the rectangle and the cutouts
rect_length = 10.0
rect_width = 5.0
cutout_size = 1.0

# Create the rectangle and extrude it first
result = cq.Workplane("XY").rect(rect_length, rect_width).extrude(1.0)

# Create the cutouts at each corner
# Adjusted to make sure cutout corners are appropriately placed
offset_x = rect_length / 2 - cutout_size / 2
offset_y = rect_width / 2 - cutout_size / 2

# Using eachCorner to make sure cutouts are at each corner
result = result.faces(">Z").workplane().eachCorner(
    lambda loc: loc.pushPoints([(-offset_x, -offset_y)]).rect(cutout_size, cutout_size).cutBlind(-1.0),
    useLocalCoordinates=True
)

# Save the result with the correct STL filename
result.val().exportStl("Refine_1.stl")
