
import cadquery as cq

# Create a rectangular sketch and extrude it
result = cq.Workplane("front").rect(10, 20).extrude(0.5)

# Add two small holes on the left side of the rectangle
result = result.faces("<X").workplane().pushPoints([(-5, 7.5), (-5, -7.5)]).hole(1)

# Export the result
result.val().exportStl("Generated.stl")
