
import cadquery as cq

# Create a rectangular sketch and extrude it
result = cq.Workplane("front").rect(10, 20).extrude(0.5)

# Add two small holes on the left side of the rectangle
# Adjust the positions to ensure the holes are visible and on the left side
result = result.faces("<X").workplane().pushPoints([(-5, 7.5), (-5, -7.5)]).hole(1)

# Export the result with the corrected STL filename
result.val().exportStl("Refine_1.stl")
