
import cadquery as cq

# Create a rectangular sketch and extrude it
result = cq.Workplane("front").rect(10, 20).extrude(0.5)

# Ensure the workplane is correct and holes are visible by using a more explicit definition of position
result = result.faces("<X").workplane(centerOption="CenterOfBoundBox").pushPoints([(-4.5, 8.5), (-4.5, -8.5)]).hole(1)

# Export the result with the correct filename 'Refine_2.stl'
result.val().exportStl("Refine_2.stl")
